--local notags = {'NOBLOCK', 'player', 'FX'}
--local function test_ground(inst, pt)
--	local tiletype = GetGroundTypeAtPosition(pt)
--	local ground_OK = tiletype ~= GROUND.ROCKY and tiletype ~= GROUND.ROAD and tiletype ~= GROUND.IMPASSABLE and
--						tiletype ~= GROUND.UNDERROCK and tiletype ~= GROUND.WOODFLOOR and 
--						tiletype ~= GROUND.CARPET and tiletype ~= GROUND.CHECKER and tiletype < GROUND.UNDERGROUND
--	
--	if ground_OK then
--	    local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 4, nil, notags) -- or we could include a flag to the search?
--		local min_spacing = inst.components.deployable.min_spacing or 2
--
--	    for k, v in(ents) do --for k, v in pairs(ents) do
--			if v ~= inst and v.entity:IsValid() and v.entity:IsVisible() and not v.components.placer and v.parent == nil then
--				if distsq( Vector3(v.Transform:GetWorldPosition()), pt) < min_spacing*min_spacing then
--					return false
--				end
--			end
--		end
--		
--		return true
--
--	end
--	return false
--	
--end

	local assets =
	{
		Asset("ANIM", "anim/dug_nightmare_bush.zip"),
		Asset("ATLAS", "images/inventoryimages/dug_nightmare_bush.xml"),
	}
	
--local function make_plantable(data)

	--local name = "dug_nightmare_bush"
	
	--local assets =
	--{
	--	Asset("ANIM", "anim/dug_nightmare_bush.zip"),
--	}
--	if data.build then
--		table.insert(assets, Asset("ANIM", "anim/dug_nightmare_bush.zip"))
--	end

	local function ondeploy(inst, pt)
		local tree = SpawnPrefab("nightmare_bush") 
		if tree then 
			tree.Transform:SetPosition(pt.x, pt.y, pt.z) 
			inst.components.stackable:Get():Remove()
			tree.components.pickable:OnTransplant()
			inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
			SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
			SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
		end 
	end
	local function fn(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		MakeInventoryPhysics(inst)
	    
		inst.AnimState:SetBank("cutstone")
		inst.AnimState:SetBuild("dug_nightmare_bush")
		inst.AnimState:PlayAnimation("idle")

		inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM
		
		inst:AddComponent("inspectable")
		inst:AddComponent("inventoryitem")
--		inst.components.inventoryitem.imagename = "dug_nightmare_bush"
	    inst.components.inventoryitem.atlasname = "images/inventoryimages/dug_nightmare_bush.xml"

		
		inst:AddComponent("fuel")
		inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL
	    

        MakeMediumBurnable(inst, TUNING.LARGE_BURNTIME)
		MakeSmallPropagator(inst)
		
	    inst:AddComponent("deployable")
	    --inst.components.deployable.test = function() return true end
	    inst.components.deployable.ondeploy = ondeploy
--	    inst.components.deployable.test = test_ground
--	    inst.components.deployable.min_spacing = data.minspace or 2
	    
	    inst:AddComponent("edible")
	    inst.components.edible.foodtype = "WOOD"
	    inst.components.edible.woodiness = 15
	return inst
end
		
		return Prefab( "common/inventory/dug_nightmare_bush", fn, assets), MakePlacer("dug_nightmare_bush_placer", "marsh_bush", "marsh_bush", "idle")